//
// Controlled Spline.js
//
// v.20130118: first release.
// v.20130118b: fixed close spline bug.

function buildUI( obj ) {

  obj.setParameter("name", "Controlled Spline");
  
  obj.addParameterFloat("approximation angle", 5, 1, 90, true, true );

  obj.addParameterBool("manual curve", 0, 0, 1, true, true);

  obj.addParameterFloat("curve", 0.35, 0, 1, true, true);
  obj.addParameterBool("close spline", 0, 0, 1, true, true);
  
  obj.setCreatorObj( true );
}

function getChildInfo( obj, cache, mat, curve, manualCurve ) {

  var len = obj.childCount();

  var controlPoints = [];
  for (var i = 0;i < len;i++) {
    var child = obj.childAtIndex( i );

    var childMat = mat.inverse().multiply( child.obj2WorldMatrix() );
    var curveTag = tagWithScriptName( child, "Controlled Spline Tag.js" );
    var childCurve = (curveTag)? curveTag.getParameter("curve") : curve;
    var controlPoints_tmp = [];

    if (manualCurve) {
      if (i + 1 < len) {
        i++;
        var cpMat = mat.inverse().multiply( obj.childAtIndex( i ).obj2WorldMatrix() );
        controlPoints_tmp.push( new Vec3D( cpMat.m03, cpMat.m13, cpMat.m23 ) );
      } else {
        controlPoints_tmp.push( undefined );
      }

      if (i + 1 < len) {
        i++;
        var cpMat = mat.inverse().multiply( obj.childAtIndex( i ).obj2WorldMatrix() );
        controlPoints_tmp.push( new Vec3D( cpMat.m03, cpMat.m13, cpMat.m23 ) );
      } else {
        controlPoints_tmp.push( undefined );        
      }
    }

    cache.push( [ new Vec3D( childMat.m03, childMat.m13, childMat.m23 ), childCurve, controlPoints ] );

    controlPoints = controlPoints_tmp;
  }

  return cache;
}

function buildObject( obj ) {
  
  var childCount = obj.childCount();
  
  if (childCount < 1) return;
  
  obj.setParameter("angle", obj.getParameter("approximation angle"), false );

  var core = obj.core();
  var curve = obj.getParameter("curve");
  var close = obj.getParameter("close spline");
  var manualCurve = obj.getParameter("manual curve");

  var i;
  var cache = [];
  var c1, c2, cp1, cp2, norm;
  

  cache = getChildInfo( obj, cache, obj.obj2WorldMatrix(), curve, manualCurve );
  
  //print( cache.length );

  var len = cache.length;
  for (i = 0;i < len;i++) {
    var p = cache[i][0]; // controll point
    
    if (i == 0) {
      
      core.move( p );
      
    } else {
      
      if (cache[i][1] == 0 && cache[i-1][1] == 0 && !manualCurve) {
        
        core.line( p );
      
      } else {
        
        if (manualCurve) {
          var cp1 = (cache[i][2].length  > 0)? cache[i][2][0] : p;
          var cp2 = (cache[i][2].length  > 1)? cache[i][2][1] : p;

        } else {
          // cp1
          if (i == 1 && !close) {
            cp1 = cache[i-1][0];
          } else {
            c1 = cache[i-1][0];
            c2 = (i == 1)? cache[ childCount-1 ][0] : cache[ i-2 ][0];
            
            cp1 = c1.add( Vec3D_normalize( p.sub( c2 ) ).multiply( Vec3D_distance( p, c1 ) * cache[i-1][1] ) );
          }
          // cp2
          if (i == childCount - 1 && !close ) {
            cp2 = p;
          } else {
            c1 = cache[i-1][0];
            c2 = (i == childCount - 1)? cache[0][0] : cache[i+1][0];
            
            cp2 = p.add( Vec3D_normalize( c1.sub( c2 ) ).multiply( Vec3D_distance( p, c1 ) * cache[i][1] ) );
          }
        }

        core.curve( cp1, cp2, p );
      }
      
    }
  }
  
  if (close && len > 2) {
    
    if (cache[0][1] == 0 && cache[len-1][1] == 0) {
      core.close();
    } else {
      
      c1 = cache[len-1][0];
      c2 = cache[len-2][0];
      
      cp1 = c1.add( Vec3D_normalize( cache[0][0].sub( c2 ) ).multiply( Vec3D_distance( cache[0][0], c1 ) * cache[len-1][1] ) );
      
      c1 = cache[len-1][0];
      c2 = cache[1][0];
      
      cp2 = cache[0][0].add( Vec3D_normalize( c1.sub( c2 ) ).multiply( Vec3D_distance( cache[0][0], c1 ) * cache[0][1] ) );
      
      core.curve( cp1, cp2, cache[0][0] );
      
    }
  }

}

var Vec3D_distance = function() {
	if( arguments.length == 1)
			return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
	var p = arguments[1].sub(arguments[0]);
	return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
}

var Vec3D_normalize = function(vec) {
  var l = vec.norm();
  if (l != 0) {
    return vec.multiply( 1/l );
  }
  return vec;
}

function tagWithScriptName(obj, scriptName) {
	var tagCount = obj.tagCount();
	var resultTag = false;
	for (var i = 0;i < tagCount;i++) {
		var tag = obj.tagAtIndex(i);
        var sn = tag.getParameter("scriptName");
		if (sn.indexOf(scriptName) != -1 && tag.getParameter("tagOn")) {
			resultTag = tag;
		}
	}
	return resultTag;
}

